************************************************************************************************
* Name			: table D3 - materials from the intervention in treatment households at fu
*
* Description	: This dofile produces summary statistics for intervention materials in 
* 				  treatment households at first follow up
************************************************************************************************

********************************************************************************
* SETTINGS 
********************************************************************************
clear 				all 
set more 			off 
set graphics 		off 
version 			15          /*Use Stata 15*/ 
set seed			16072015   	/* This is the seed number that was used to create the bootstrapped samples for estimation of the model in the paper */ 

* Options for data to create 
global testerFE 	no 			/*Take out tester FE before standardizing measures*/ 
global invar 		no 			/*Incorporate intercepts in the measurement system for when we will allow for measurement system variance*/ 
global pure 		no 			/*Only pure control and pure stimulation groups*/ 

* Globals of directories, variable groups and others 
run "$dir_statacode\globals.do" 

* Dataset with standardized measures 
use "$dir_data\finalsample_nonstandardized.dta", clear 


********************************************************************************
* SUMMARY STATISTICS 
********************************************************************************
cap log close 
log using "$dir_output/TableD3.log", replace
sum  NtoysgivenML1 NtoysmadeML1 Npicbooksi1 if treat==2
log close 
